<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    DTR1 CD - Concept Descriptor
    Status: draft
    TODO: check for codes/codesystemen in translations
-->
<rule abstract="true" id="CD" xmlns="http://purl.oclc.org/dsdl/schematron">
    <extends rule="ANY"/>
    <assert role="error" test="@nullFlavor or @code or (hl7:originalText and not(hl7:originalText/@nullFlavor))">dtr1-1-CD: null or code and/or originalText</assert>
    <assert role="error" test="@codeSystem or not(@code)">dtr1-2-CD: code requires codeSystem</assert>
    <assert role="error" test="@codeSystem or not(@codeSystemName)">dtr1-3-CD: codeSystemName only if codeSystem</assert>
    <assert role="error" test="@codeSystem or not(@codeSystemVersion)">dtr1-4-CD: codeSystemVersion only if codeSystem</assert>
    <assert role="error" test="@code or not(@displayName)">dtr1-5-CD: displayName only if code</assert>
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@code))">dtr1-6-CD: no code if null</assert>
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@displayName))">dtr1-7-CD: no displayName if null</assert>
    
    <assert role="error" test="not(hl7:translation/hl7:originalText)">dtr1-8-CD: no originalText on translations</assert>
    <!-- According to DTr1 abstract:
        Each translation may, however, also contain translations. Thus, when a code is translated multiple times the information 
        about which code served as the input to which translation will be preserved.
    -->
    <!--<assert role="error" test="not(hl7:translation/hl7:translation)">dtr1-9-CD: no translation on translations</assert>-->
    <assert role="error" test="not(hl7:translation/@nullFlavor)">dtr1-10-CD: no null on translations</assert>

    <assert role="error" test="hl7:translation/@codeSystem or not(hl7:translation/@code)">dtr1-11-CD: translation code requires codeSystem</assert>
    <assert role="error" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)">dtr1-12-CD: translation codeSystemName only if codeSystem</assert>
    <assert role="error" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)">dtr1-13-CD: translation codeSystemVersion only if codeSystem</assert>
    <assert role="error" test="hl7:translation/@code or not(hl7:translation/@displayName)">dtr1-14-CD: translation displayName only if code</assert>

    <report role="warning" test="matches(@displayName,'[\r\n\t]')">dtr1-15-CD: it looks like there are formatting instructions in attribute @displayName. Please note that this may lead to
        interoperability problems.</report>
    
    <let name="code" value="@code"/>
    <report role="warning" test="@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))"
        >Datatype CD: waarschuwing: onbekend codeSystem '<value-of select="@codeSystem"/>' gevonden met codeSystemName 
        '<value-of select="./@codeSystemName"/>'. Bestand '<value-of select="concat('../vocab/',@codeSystem,'.xml')"/>' ontbreekt.</report>
    <report role="warning" test="hl7:translation[@codeSystem and not(doc-available(concat('../vocab/',@codeSystem,'.xml')))]"
        >Datatype CD: waarschuwing: onbekend codeSystem '<value-of select="hl7:translation/@codeSystem"/>' in translation</report>
    <report role="warning" test="if (@codeSystem and doc-available(concat('../vocab/',@codeSystem,'.xml')) and (
        document(concat('../vocab/',@codeSystem,'.xml'))/*[@codeStrength='CNE'] or
        not(document(concat('../vocab/',@codeSystem,'.xml'))/*/@codeStrength))) then ( 
        not(document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:code[@code=$code]) ) else ( 0=1 )"
        >Datatype CD: waarschuwing: onbekende code '<value-of select="$code"/>' gevonden in codeSystem '<value-of select="@codeSystem"/>'
        gevonden met displayName '<value-of select="./@displayName"/>'. Waarde ontbreekt in 
        '<value-of select="concat('../vocab/',@codeSystem,'.xml')"/>' (<value-of select="document(concat('../vocab/',@codeSystem,'.xml'))/*/hl7:name"/>).</report>
    
    <assert role="error" test="not(hl7:translation/hl7:originalText)">Datatype CD: no originalText on translations</assert>
    <assert role="error" test="not(hl7:translation/hl7:translation)">Datatype CD: no translation on translations</assert>
    <assert role="error" test="not(hl7:translation/@nullFlavor)">Datatype CD: no null on translations</assert>
    
    <assert role="error" test="hl7:translation/@codeSystem or not(hl7:translation/@code)">Datatype CD: translation code requires codeSystem</assert>
    <assert role="error" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemName)">Datatype CD: translation codeSystemName only if codeSystem</assert>
    <assert role="error" test="hl7:translation/@codeSystem or not(hl7:translation/@codeSystemVersion)">Datatype CD: translation codeSystemVersion only if codeSystem</assert>
    <assert role="error" test="hl7:translation/@code or not(hl7:translation/@displayName)">Datatype CD: translation displayName only if code</assert>
    
    <let name="codeValue" value="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>
    <assert role="error" test="not(../hl7:id/@root='2.16.528.1.1007.3.1') or 
        document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]"
        >Datatype CD: UZI rolcode attribuut code moet een geldige RoleCodeNL bevatten</assert>
    
    <let name="codeValue" value="self::hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>
    <assert role="error" test="@nullFlavor or not(../hl7:id/@root='2.16.528.1.1007.3.3') or 
        document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"
        >Datatype CD: organisatie rolcode attribuut code moet een geldige AssignedRoleType bevatten</assert>
</rule>